package drm.genetics;

import java.util.Random;
import java.util.Vector;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractMutation implements Mutation {
  protected Random random = new Random();

  protected double percentage = 0.01;

  public AbstractMutation() {
  }

  public AbstractMutation(double percentage) {
    setPercentage(percentage);
  }

  public void setPercentage(double percentage) {
    this.percentage = percentage;
  }

  public double getPercentage() {
    return percentage;
  }

  public Individual mutate(Individual individ) {
    Individual ind = null;
    try {
      ind = (Individual)individ.getClass().newInstance();
      ind.accessGenome(individ.getGenome());
      mutateSame(ind);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return ind;
  }


  private Vector randomNumbers = new Vector();
  /**
   * generates a sequence of random numbers where all numbers differ
   *
   * @param     max     maximal number available to get.
   * @param     count   number of numbers to produce.
   * @return    sequence of different random numbers.
   */
  protected int[] randomNumbers(int max, int count){
    if (randomNumbers.size() != max) {
      randomNumbers = new Vector(max);
      for (int i=0; i<max; i++) randomNumbers.add(new Integer(i));
    }

    Vector num = new Vector(randomNumbers);
    int[] numbers = new int[count];
    for (int i=0; i<count; i++) numbers[i] =
          ((Integer)num.remove(random.nextInt(num.size()))).intValue();
    return numbers;
  }
}