package drm.genetics;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractIndividual implements Individual {
  protected Gene[] genome = {};

  /**
   * Gaunamas tiesioginis priėjimas prie genų rinkinio
   * @return genomas
   */
  public Gene[] accessGenome() {
    return genome;
  }

  /**
   * Individo genomas nustatomas į nurodytą genomą
   * @param genome genomas
   */
  public void accessGenome(Gene[] genome) {
    this.genome = genome;
  }

  /**
   * Gaunama genomo kopija
   * @return genomo kopija
   */
  public Gene[] getGenome() {
    Gene[] out = new Gene[genome.length];
    System.arraycopy(genome, 0, out, 0, genome.length);
    return out;
  }

  /**
   * Individo genomui priskiriama nurodyto genomo kopija
   * @param genome genomas
   */
  public void setGenome(Gene[] genome) {
    this.genome = new Gene[genome.length];
    System.arraycopy(genome, 0, this.genome, 0, genome.length);
  }

  /**
   * Palygina du individus.
   * @param individual individas palyginimui
   * @return palyginimo rezultatas = -1, 0, 1.
   */
  public int compareTo(Object individual) {
    double ths = getWeight();
    double otr = ((Individual)individual).getWeight();
    int out = 1;
    if (ths > otr) out = -1;
    if (individual.equals(this)) out = 0;
    return out;
  }

  /**
   * individo kokybė
   */
  protected double weight = Double.NEGATIVE_INFINITY;

  public double getWeight() {
    return weight;
  }

  public void setWeight(double weight) {
    this.weight = weight;
  }

  public Individual copy() {
    AbstractIndividual ind = null;
    try {
      ind = (AbstractIndividual)this.getClass().newInstance();
      ind.accessGenome(getGenome());
      ind.weight = weight;
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return ind;
  }
}