package drm.genetics;

import java.util.Random;

/**
 * <p>Title: Genetinių Algoritmų paketas</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: KTU</p>
 * @author Mantas Balnys
 * @version 1.0
 */

public abstract class AbstractCrossover implements Crossover {
  protected Random random = new Random();
  protected int type = TYPE_SINGLE_POINT;

  public AbstractCrossover() {
  }

  public AbstractCrossover(int type) {
    setType(type);
  }

  public void setType(int type) {
    this.type = type;
  }

  public int getType() {
    return type;
  }

  public Individual cross(Individual individ1, Individual individ2) {
    Individual ind1 = null;
    Individual ind2 = null;
    try {
      ind1 = (Individual)individ1.getClass().newInstance();
      ind2 = (Individual)individ2.getClass().newInstance();
      ind1.accessGenome(individ1.getGenome());
      ind2.accessGenome(individ2.getGenome());
      crossSame(ind1, ind2);
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return ind1;
  }
}